#!/bin/bash
set -e

[[ "$EUID" -ne 0 ]] && { echo "❌ Rode com sudo"; exit 1; }

BASE_DIR="$(dirname "$(readlink -f "$0")")"
USER_NAME="$SUDO_USER"
USER_HOME="/home/$USER_NAME"
DBUS_ADDR="unix:path=/run/user/$(id -u "$USER_NAME")/bus"
APPLET_NAME="CinnVIIStarkMenu@NikoKrause"

run_as_user() { sudo -u "$USER_NAME" DBUS_SESSION_BUS_ADDRESS="$DBUS_ADDR" "$@"; }

echo "🚀 Instalando tema Windows XP..."

# Copiar arquivos
mkdir -p "$USER_HOME"/{.themes,.icons,.local/share/cinnamon/applets}
rm -rf "$USER_HOME/.themes/Windows-XP-Luna" "$USER_HOME/.icons/Windows-XP" "$USER_HOME/.local/share/cinnamon/applets/$APPLET_NAME"
cp -r "$BASE_DIR/themes/Windows-XP-Luna" "$USER_HOME/.themes/"
cp -r "$BASE_DIR/icons/Windows-XP" "$USER_HOME/.icons/"
cp -r "$BASE_DIR/cinnamon/$APPLET_NAME" "$USER_HOME/.local/share/cinnamon/applets/"
chown -R "$USER_NAME:$USER_NAME" "$USER_HOME"/{.themes,.icons,.local}

# Aplicar temas
run_as_user gsettings set org.cinnamon.desktop.interface icon-theme "Windows-XP"
run_as_user gsettings set org.cinnamon.desktop.interface gtk-theme "Windows-XP-Luna"
run_as_user gsettings set org.cinnamon.theme name "Windows-XP-Luna"

# Configurar applet
APPLETS=$(run_as_user gsettings get org.cinnamon enabled-applets)
if ! echo "$APPLETS" | grep -q "$APPLET_NAME"; then
    NEXT_ID=$(($(echo "$APPLETS" | grep -oP ':\K\d+' | sort -n | tail -1) + 1))
    APPLETS=$(echo "$APPLETS" | sed "s/]$/, 'panel1:left:0:$APPLET_NAME:$NEXT_ID']/")
    run_as_user gsettings set org.cinnamon enabled-applets "$APPLETS"
fi

sleep 2

# Copiar configurações do JSON
CONFIG_DIR="$USER_HOME/.cinnamon/configs/$APPLET_NAME"
mkdir -p "$CONFIG_DIR"
cp "$BASE_DIR/cinnamon/$APPLET_NAME/settings.json" "$CONFIG_DIR/settings.json"
chmod 644 "$CONFIG_DIR/settings.json"
chown "$USER_NAME:$USER_NAME" "$CONFIG_DIR/settings.json"

# -------------------------
# Aplicar wallpaper
# -------------------------
WALLPAPER_FILE="$BASE_DIR/imagens/wallpaper/xp.webp"
if [[ -f "$WALLPAPER_FILE" ]]; then
    echo "🖼️ Aplicando wallpaper: $(basename "$WALLPAPER_FILE")"
    run_as_user gsettings set org.cinnamon.desktop.background picture-uri "file://$WALLPAPER_FILE"
    run_as_user gsettings set org.cinnamon.desktop.background picture-options "zoom"
else
    echo "⚠️ Wallpaper não encontrado: $WALLPAPER_FILE"
fi
# -------------------------

# Reiniciar Cinnamon
run_as_user dbus-send --session --type=method_call --dest=org.Cinnamon.LookingGlass /org/Cinnamon/LookingGlass org.Cinnamon.LookingGlass.Eval string:'global.reexec_self()' 2>/dev/null &

echo "✅ Instalação completa! Faça logout/login se necessário."